if (Meteor.isClient) {
    // client code goes here
    Template.todos.helpers({
        'todo': function () {
            return Todos.find();
        }
    });

    Template.addTodo.events({
        /// events go here
        'submit form': function (event) {
            event.preventDefault();
            var todoName = $('[name="todoName"]').val();
            Todos.insert({
                name: todoName,
                completed: false,
                createdAt: new Date()
            });
            $('[name="todoName"]').val('');
        }
        
    });

    Template.todoItem.events({
        // events go here
        'click .delete-todo': function (event) {
            event.preventDefault();
            var documentId = this._id;
            var confirm = window.confirm("Delete this task?");
            if (confirm) {
                Todos.remove({ _id: documentId });
            }
        }
    });

    Template.sensorTable.helpers({
        sensors: function () {
            return Sensors.find();
        }
    });
    Template.sensorRow.helpers({
        datetime: function () {
            return Date(Template.currentData().timestamp);
        }
    });

    Meteor.subscribe('sensorsTopic');
}

if (Meteor.isServer) {
    // server code goes here
    Meteor.publish('sensorsTopic', function () {
        // only publish when logged-in users request publishing
        if (this.userId) {
            return [Sensors.find()];
        }
    });
}

Todos = new Mongo.Collection('todos');
Sensors = new Mongo.Collection('sensors');

Router.route('/leaderboard');

Router.route('/todos');


Router.configure({
    layoutTemplate: 'mainLayout'
});

// Default route
Router.route('/', function () {
    Router.go('home');
});

Router.route('/home', function () {

    this.render('home');
});

Router.route('/dashboard', function () {
    this.render('dashboard');
});